// compiler.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include "common.h"
#include "tree.h"
#include "error.h"
#include "printTree.h"
#include "weed.h"
#include "symbol.h"
#include "typechecking.h"
#include "resourcecalc.h"
#include "code.h"
#include "emit.h"
#include "scriptHeaders.h"
#include "constanttable.h"
#include "assembler.h"
#include "asmutils.h"

SCRIPT*		theScript;
//****************************************************************************************************************
//Trida zapouzdrujic funkce kompileru skriptu pro nas jazyk
//Obsahuje jen public promenne objektovych typu prislusejicich
//modulu kompileru
//****************************************************************************************************************
class		CCompiler
{
public:
	CPrintTree				m_module_PrintTree;					//modul pro vypis AST stromu do souboru
	CWeeding				m_module_Weeding;					//modul pro pleni skriptu, tj. nalezeni zakladnich chyb
	CSymbolChecking			m_module_SymbolChecking;			//modul pro kontrolu symbolu
	CTypeChecking			m_module_TypeChecking;
	CResourceCalculations	m_module_ResourceCalculations;		//modul pro vypocet zdroju
	CCode					m_module_Coding;					//modul pro vytvoreni kodu v assembleru jazyka
	CEmit					m_module_Emit;						//modul pro vypis assembly kodu do souboru
	CAssembler				m_module_Assembler;					//modul pro prevedeni assembly souboru do binarni formy skriptu, programu
}			theCompiler;

//prototyp parsovaci funkce
int yyparse();

//hlavni funkce
int _tmain(int argc, _TCHAR* argv[])
{
	char*	outputFile = NULL;

	//nastaveni standartniho vystupu na vystup konzole
	setbuf(stdout,NULL);			
    setbuf(stderr,NULL);	

	//sestaveni jmena logovaciho souboru
	outputFile = stringConcat(argv[1],BUILDLOG_EXT,NULL);

	//otevreni logovaciho souboru
    theLog.OpenLogFile(outputFile);

	//pokud je pocet argumentu mensi nez dva, nemohlo byt zadano jmeno souboru ktery mame
	//zkompilovat. Prvni argument je vzdy cesta z ktere byl kompiler spusten
	if (argc < 2)
	{
		//vypis hlasku o neplatnem pouziti kompileru a skonci
		printf("Usage: compiler <file>\n");
		exit(1);
	}
	else
	{
		//jmeno souboru bylo zadano, otevri soubor na standartni vstup, coz se vlastne rovna tomu
		//jako kdybychom soubor rucne vepsali do konzole jako do prikazoveho radku
		if (freopen(argv[1],"r",stdin) != NULL)
		{
			theLog.TraceC("Parsing...\n");
			theLog.TraceF("Parsing..<br>");
			line_number = 1;
			yyparse();
		}
		else
		{
			//informovani pokud se nepodari otevrit soubor
			theLog.TraceC("Couldn't open file: %s\n",argv[1]);
			theLog.TraceF("Couldn't open file: %s<br>",argv[1]);
			exit(1);
		}
	}

	//zkontroluj chyby
	theLog.ErrorCheck();
	theLog.TraceF("Script AST:<br><p>");
	theCompiler.m_module_PrintTree.PrintToLog(true);
	theCompiler.m_module_PrintTree.Process(theScript);
	theLog.TraceF("</p>");

	theLog.TraceC("Weeding...\n");
	theLog.TraceF("Weeding...<br>");
	theCompiler.m_module_Weeding.Process(theScript);
	theLog.ErrorCheck();

	theCompiler.m_module_PrintTree.Process(theScript);

	theLog.TraceC("Checking symbols...\n");
	theLog.TraceF("Checking symbols...<br>");
	theCompiler.m_module_SymbolChecking.Process(theScript);
	theLog.ErrorCheck();

	theCompiler.m_module_PrintTree.Process(theScript);

	theLog.TraceC("Type Checking...\n");
	theLog.TraceF("Type Checking...<br>");
	theCompiler.m_module_TypeChecking.Process(theScript);
	theLog.ErrorCheck();

	theLog.TraceC("Calculating resources...\n");
	theLog.TraceF("Calculating resources...<br>");
	theCompiler.m_module_ResourceCalculations.Process(theScript);
	theLog.ErrorCheck();

	theLog.TraceC("Coding...\n");
	theLog.TraceF("Coding...<br>");
	theCompiler.m_module_Coding.Process(theScript);
	theLog.ErrorCheck();

	theLog.TraceC("Emitting...\n");
	theLog.TraceF("Emitting...<br>");
	outputFile = stringConcat(argv[1],ASSEMBLY_EXT,NULL);
	theCompiler.m_module_Emit.Process(theScript,outputFile);
	
	theLog.TraceC("Assembling...\n");
	theLog.TraceF("Assembling...<br>");
	theCompiler.m_module_Assembler.Process(outputFile);
	theLog.ErrorCheck();

	return 0;
}

